<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  echo json_encode(['message' => 'Método inválido']);
  exit;
}

$spreadsheetId = $_POST['spreadsheetId'] ?? '';
$mensagem = $_POST['mensagem'] ?? '';

if (empty($spreadsheetId) || empty($mensagem)) {
  echo json_encode(['message' => 'Campos obrigatórios faltando']);
  exit;
}

$tmpFilePath = $_FILES['imagem']['tmp_name'] ?? null;
$originalName = $_FILES['imagem']['name'] ?? null;

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://seu-n8n-endpoint/webhook/disparo');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);

$postFields = [
  'spreadsheetId' => $spreadsheetId,
  'mensagem' => $mensagem,
];

if ($tmpFilePath && file_exists($tmpFilePath)) {
  $postFields['imagem'] = new CURLFile($tmpFilePath, mime_content_type($tmpFilePath), $originalName);
}

curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
$response = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
  echo json_encode(['message' => 'Erro ao enviar para n8n: ' . $error]);
} else {
  echo json_encode(['message' => 'Disparo iniciado com sucesso!', 'response' => json_decode($response, true)]);
}
?>
